(function() {
  //    FILE:EventDayPlanView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'jqueryui/datepicker', 'models/bookingstructures/BookingstructuresModel', 'collections/event/EventCollection', 'models/time/TimeModel', 'models/objects/ObjectModel', 'models/project/ProjectModel', 'models/event/EventModel', 'views/event/EventView', 'views/request/AddRequestView', 'views/menu/MenuView', "views/project/ProjectDetailView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, DatePicker, BookingstructuresModel, EventCollection, TimeModel, ObjectModel, ProjectModel, EventModel, EventView, AddRequestView, MenuView, ProjectDetailView) {
    var EventDayPlanView;
    return EventDayPlanView = class EventDayPlanView extends Backbone.View {
      initialize(usr, eventsCol, obj1) {
        this.usr = usr;
        this.eventsCol = eventsCol;
        this.obj = obj1;
        this.eventsCol.on('create', this.__update_events_dayplan, this);
        this.eventsCol.on('change', this.__update_events_dayplan, this);
        this.bookingStructures = new BookingstructuresModel();
        this.bookingStructures.get_booking_structures(this.usr);
        this.dayToShow = Moment();
        this.time = new TimeModel();
        //@eventsCol.get_day_events(@usr,@dayToShow,@obj)
        this.viewable = this.usr.__can_view_event_in_time_frame(this.dayToShow);
        return this.bookable = this.usr.__can_create_event_in_time_frame(this.dayToShow);
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'EventDayPlanView'
        };
      }

      events() {
        return {
          'tap #id-btn-datepicker': 'btnDatePickerClicked',
          'tap #id-btn-datepicker-tomorrow': 'btnTomorrowClicked',
          'tap #id-btn-datepicker-yesterday': 'btnYesterdayClicked',
          //EVENT CLICKED
          'tap .project-name': 'btnProjectClicked',
          'tap .booking-name': 'btnEventClicked',
          'tap .dayplan-row': 'btnObjectClicked',
          //Click back => OBJECT VIEWINIG
          'tap #id-btn-backToObject': 'btnBackToObjectsClicked'
        };
      }

      render() {
        var previousView, template;
        template = Handlebars.templates['EventDayPlanView'];
        previousView = 'none';
        if (this.obj) {
          previousView = this.obj.get('previousView');
        }
        this.$el.html(template({
          user: this.usr.toJSON(),
          dayToShow: this.dayToShow.format('Do MMM'),
          previousView: previousView
        }));
        this.$el.attr('id', 'id-EventDayPlanView');
        this.$el.find('#id-h1-navbar-title').text(this.obj.get('objectName'));
        this.addSidePanel();
        return this.$el;
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      //# END OF HANDLING NAVIGATION

        //DATE SELECTOR
      btnTomorrowClicked(event) {
        var tomorrow;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        tomorrow = this.dayToShow.add('days', 1);
        this.dayToShow = tomorrow;
        this.viewable = this.usr.__can_view_event_in_time_frame(tomorrow);
        this.bookable = this.usr.__can_create_event_in_time_frame(tomorrow);
        $('#id-btn-datepicker .ui-btn-text').text(tomorrow.format('Do MMM'));
        this.eventsCol.get_day_events(this.usr, tomorrow.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnYesterdayClicked(event) {
        var yesterday;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        yesterday = this.dayToShow.subtract('days', 1);
        this.dayToShow = yesterday;
        this.viewable = this.usr.__can_view_event_in_time_frame(yesterday);
        this.bookable = this.usr.__can_create_event_in_time_frame(yesterday);
        $('#id-btn-datepicker .ui-btn-text').text(yesterday.format('Do MMM'));
        this.eventsCol.get_day_events(this.usr, yesterday.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnDatePickerClicked(event) {
        var firstDay, selDate, that;
        event.preventDefault();
        event.stopPropagation();
        that = this;
        selDate = new Date(this.dayToShow.format('YYYY-MM-DD'));
        if (!this.usr.get('weekStartsOnSunday')) {
          firstDay = 1;
        } else {
          firstDay = 0;
        }
        $('#id-input-datepicker').datepicker({
          dateFormat: 'yy-mm-dd',
          firstDay: firstDay,
          maxDate: window.MAXDATE,
          onSelect: function(dateText, dtp) {
            $.mobile.loading('show');
            that.dayToShow = Moment(dateText, 'YYYY-MM-DD');
            that.viewable = that.usr.__can_view_event_in_time_frame(that.dayToShow);
            that.bookable = that.usr.__can_create_event_in_time_frame(that.dayToShow);
            $('#id-btn-datepicker .ui-btn-text').text(Moment(dateText).format('Do MMM'));
            that.eventsCol.get_day_events(that.usr, that.dayToShow, that.obj);
            return that.eventsCol.trigger('change');
          }
        });
        $('#id-input-datepicker').datepicker("option", "defaultDate", selDate);
        return $('#id-input-datepicker').datepicker('show');
      }

      btnProjectClicked(event) {
        var btn, prj, projectID, type, view;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        projectID = btn.attr('data-nodeID');
        type = btn.attr('data-nodeType');
        if (type === 'project') {
          //GET PROEJCT DETAILS
          prj = new ProjectModel();
          prj.get_project_detail(this.usr, projectID);
          if (!ProjectDetailView) {
            ProjectDetailView = require("views/project/ProjectDetailView");
          }
          view = new ProjectDetailView(this.usr, prj);
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      btnEventClicked(event) {
        var btn, day, eventID;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        eventID = btn.attr('data-bookingID');
        day = btn.siblings().find('.dayplan-row').attr('data-day');
        if (!EventModel) {
          EventModel = require("models/event/EventModel"); //MAKING SURE IS LOADED
        }
        event = new EventModel({
          eventID: eventID,
          day: day
        });
        event.get_details_event(this.usr.get('sessionID'), 'dayplan');
        return event.on('eventFilled', _.bind(this.__go_to_event_view, this, event));
      }

      __go_to_event_view(event) {
        var view;
        this.bookingStructures.get_booking_structures(this.usr);
        if (!EventView) {
          EventView = require("views/event/EventView"); //MAKING SURE IS LOADED
        }
        view = new EventView(this.usr, this.bookingStructures, this.eventsCol, event, this.dayToShow, this.obj);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnObjectClicked(event) {
        var cur, obj, objID, objName, objType;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        objID = cur.attr('data-objectID');
        objName = cur.attr('data-objectName');
        objID = cur.attr('data-objectID');
        objType = cur.attr('data-objectType');
        obj = new ObjectModel({
          previousView: 'objectBrowser'
        });
        obj.on('change', this.showEventList, this);
        /*
        Last true parameter is because we have the data locally storaged, and we dont need extra info from the detail_object call
        AVOIDING A NETWORK CALL
        */
        return obj.set_object_detail(this.usr, objName, objID, objType, '', '');
      }

      // obj.set_object_detail(@usr,objName,objID,objType,objViewName,objClassID)
      showEventList(objMdl) {
        var EventListView, ev, type, view;
        //### ASK FOR EVENTS TOO MISSING OBJECT ID CUSTOM
        if (!EventCollection) {
          EventCollection = require("collections/event/EventCollection");
        }
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        ev = new EventCollection();
        ev.set_day_events(this.usr, this.dayToShow, objMdl);
        type = objMdl.get('objectType');
        if (type === 'sharedEventsView' || type === 'objectClass' || type === 'smartEventsView' || type === 'allEvents') {
          view = new EventDayPlanView(this.usr, ev, objMdl);
        } else {
          view = new EventListView(this.usr, ev, objMdl, this.dayToShow);
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      __update_events_dayplan(col) {
        var dayPlan, div, events, note, showNote, that;
        div = $('#id-div-events-dayplan');
        div.empty();
        that = this;
        showNote = this.usr.get('showNoteOnDayPlanView');
        if (col instanceof EventCollection) {
          events = col.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = col.get_dayNote(that.dayToShow);
          dayPlan = col.get_day_plan(that.dayToShow);
        } else {
          events = this.eventsCol.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = this.eventsCol.get_dayNote(that.dayToShow);
          dayPlan = this.eventsCol.get_day_plan(that.dayToShow);
        }
        if (note) {
          $('#id-p-dayNote').text(note.note);
          $('#id-p-dayNote').show();
        } else {
          $('#id-p-dayNote').hide();
        }
        return _.each(dayPlan != null ? dayPlan.DayPlanNodes : void 0, function(nodes) {
          var DayPlanNodes, header, node, table;
          if (_.isArray(nodes)) {
            return _.each(nodes, function(node) {
              var DayPlanNodes, header, table;
              table = '<table class="table-event-dayplan">';
              header = `<thead><tr ><td colspan='2' class='project-name' data-nodeID=\"${node.nodeID}\" data-nodeType=\"${node.nodeType}\"><span class='fwi-project'/> ${node.nodeName}</td></tr></thead>`;
              table += header;
              DayPlanNodes = that.__find_day_plan_node(node);
              table += that.__get_html_for_event(DayPlanNodes);
              return div.append(table);
            });
          } else {
            node = nodes;
            table = '<table class="table-event-dayplan">';
            header = `<thead><tr ><td colspan='2' class='project-name' data-nodeID=\"${node.nodeID}\" data-nodeType=\"${node.nodeType}\"><span class='fwi-project'/> ${node.nodeName}</td></tr></thead>`;
            table += header;
            DayPlanNodes = that.__find_day_plan_node(node);
            table += that.__get_html_for_event(DayPlanNodes);
            return div.append(table);
          }
        });
      }

      __get_html_for_event(DayPlanNodes) {
        var booking, der, divEvent, dpn, ev, eventID, events, izq, nodeID, note, showNote, table, that, timeIn, tr;
        that = this;
        table = '';
        tr = '';
        showNote = this.usr.get('showNoteOnDayPlanView');
        if (_.isArray(DayPlanNodes)) {
          _.each(DayPlanNodes, function(dpn) {
            var booking, der, divEvent, ev, events, izq, nodeID, note, timeIn;
            events = dpn.Event;
            booking = dpn.nodeName;
            nodeID = dpn.nodeID;
            tr = `<tr class='trEvent'><td data-bookingID=\"${nodeID}\" class='booking-name'>${booking}</td><td>`;
            if (_.isArray(events)) {
              divEvent = "<div  class='div-event-dayplan'>";
              _.each(events, function(ev) {
                var der, izq, note, timeIn;
                //eventID = ev.eventID
                izq = ev.objectName;
                der = ev.objectClassName;
                note = ev.note;
                timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
                //timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'),10),parseInt(that.usr.get('usesAMPM'),10),parseFloat(ev.timeOut))
                divEvent += `<span class=\"dayplan-row\" data-day=\"${ev.day}\" data-objectID=\"${ev.objectID[0]}\" data-objectName=\"${ev.objectName}\" data-objectType=\"${ev.objectType}\">`;
                if (ev.isAlldayEvent) {
                  divEvent += "<span class='timeEvent'>All Day</span>";
                } else {
                  //NOT SHOWING TIME OUT BECAUSE IT DOES NOT FIT (SAME iOS)
                  divEvent += `<span class='timeEvent'>${timeIn}</span>`;
                }
                divEvent += `<span class='name-izq'>${izq}</span>`;
                if (note && showNote) {
                  divEvent += `<span class='note-izq'> / ${note} </span>`;
                }
                if (der) {
                  divEvent += `<span class='name-der'>${der}</span>`;
                }
                return divEvent += '</span>';
              });
              divEvent += '</div>';
              tr += divEvent;
            } else if (events) {
              divEvent = "<div  class='div-event-dayplan'>";
              ev = events;
              //eventID = ev.eventID
              izq = ev.objectName;
              der = ev.objectClassName;
              note = ev.note;
              timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
              //timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'),10),parseInt(that.usr.get('usesAMPM'),10),parseFloat(ev.timeOut))
              divEvent += `<span class=\"dayplan-row\" data-day=\"${ev.day}\" data-objectID=\"${ev.objectID[0]}\" data-objectName=\"${ev.objectName}\" data-objectType=\"${ev.objectType}\">`;
              if (ev.isAlldayEvent) {
                divEvent += "<span class='timeEvent'>All Day</span>";
              } else {
                //NOT SHOWING TIME OUT BECAUSE IT DOES NOT FIT (SAME iOS)
                divEvent += `<span class='timeEvent'>${timeIn}</span>`;
              }
              divEvent += `<span class='name-izq'>${izq}</span>`;
              if (note && showNote) {
                divEvent += `<span class='note-izq'> / ${note} </span>`;
              }
              if (der) {
                divEvent += `<span class='name-der'>${der}</span>`;
              }
              divEvent += '</span>';
              divEvent += '</div>';
              tr += divEvent;
            }
            return table += tr;
          });
        } else if (DayPlanNodes) {
          dpn = DayPlanNodes;
          events = dpn.Event;
          booking = dpn.nodeName;
          nodeID = dpn.nodeID;
          tr = `<tr class='trEvent'><td data-bookingID=\"${nodeID}\" class='booking-name'>${booking}</td><td>`;
          if (_.isArray(events)) {
            divEvent = "<div  class='div-event-dayplan'>";
            _.each(events, function(ev) {
              var der, eventID, izq, note, timeIn;
              eventID = ev.eventID;
              izq = ev.objectName;
              der = ev.objectClassName;
              note = ev.note;
              timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
              //timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'),10),parseInt(that.usr.get('usesAMPM'),10),parseFloat(ev.timeOut))
              divEvent += `<span class=\"dayplan-row\" data-day=\"${ev.day}\" data-objectID=\"${ev.objectID[0]}\" data-objectName=\"${ev.objectName}\" data-objectType=\"${ev.objectType}\">`;
              if (ev.isAlldayEvent) {
                divEvent += "<span class='timeEvent'>All Day</span>";
              } else {
                //NOT SHOWING TIME OUT BECAUSE IT DOES NOT FIT (SAME iOS)
                divEvent += `<span class='timeEvent'>${timeIn}</span>`;
              }
              divEvent += `<span class='name-izq'>${izq}</span>`;
              if (note && showNote) {
                divEvent += `<span class='note-izq'> / ${note} </span>`;
              }
              if (der) {
                divEvent += `<span class='name-der'>${der}</span>`;
              }
              return divEvent += '</span>';
            });
            divEvent += '</div>';
            tr += divEvent;
          } else if (events) {
            divEvent = "<div  class='div-event-dayplan'>";
            ev = events;
            eventID = ev.eventID;
            izq = ev.objectName;
            note = ev.note;
            der = ev.objectClassName;
            timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
            //timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'),10),parseInt(that.usr.get('usesAMPM'),10),parseFloat(ev.timeOut))
            divEvent += `<span class=\"dayplan-row\" data-day=\"${ev.day}\" data-objectID=\"${ev.objectID[0]}\" data-objectName=\"${ev.objectName}\" data-objectType=\"${ev.objectType}\">`;
            if (ev.isAlldayEvent) {
              divEvent += "<span class='timeEvent'>All Day</span>";
            } else {
              //NOT SHOWING TIME OUT BECAUSE IT DOES NOT FIT (SAME iOS)
              divEvent += `<span class='timeEvent'>${timeIn}</span>`;
            }
            divEvent += `<span class='name-izq'>${izq}</span>`;
            if (note && showNote) {
              divEvent += `<span class='note-izq'> / ${note} </span>`;
            }
            if (der) {
              divEvent += `<span class='name-der'>${der}</span>`;
            }
            divEvent += '</span>';
            divEvent += '</div>';
            tr += divEvent;
          }
          table += tr;
        }
        return table += '</td></tr></table>';
      }

      __find_day_plan_node(node) {
        var DayPlanNodes;
        DayPlanNodes = node.DayPlanNode;
        if (!DayPlanNodes) {
          DayPlanNodes = node;
        }
        if (_.has(DayPlanNodes, 'DayPlanNode')) {
          return this.__find_day_plan_node(DayPlanNodes);
        } else {
          return DayPlanNodes;
        }
      }

      btnBackToObjectsClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
